/*
 * Decompiled with CFR 0.152.
 */
package me.dewgs.reachdisplay;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import me.dewgs.reachdisplay.color.Color;
import me.dewgs.reachdisplay.commands.ReachDisplayModCommand;
import me.dewgs.reachdisplay.screen.ReachDisplayGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="reachdisplaymod", name="Reach Display Mod", version="1.0", acceptedMinecraftVersions="[1.8.9]")
public class ReachDisplayMod {
    private Minecraft mc;
    private String rangeText = "Hasn't attacked";
    private boolean enabled = true;
    private boolean showGui;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int addX = 0;
    private int addY = 0;
    private int currentColorIndex;
    private long lastAttack;

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new ReachDisplayModCommand(this));
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mc = Minecraft.func_71410_x();
        this.loadConfig();
        System.out.println("Successfully initialized Reach Display Mod 1.0 by dewgs");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttack(AttackEntityEvent event) {
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && this.mc.field_71476_x.field_72308_g.func_145782_y() == event.target.func_145782_y()) {
            Vec3 vec3 = this.mc.func_175606_aa().func_174824_e(1.0f);
            double range = this.mc.field_71476_x.field_72307_f.func_72438_d(vec3);
            this.rangeText = new DecimalFormat(".##").format(range) + " blocks";
        } else {
            this.rangeText = "Not on target?";
        }
        this.lastAttack = System.currentTimeMillis();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if ((this.mc.field_71462_r == null || this.mc.field_71462_r instanceof ReachDisplayGuiScreen) && this.mc.field_71441_e != null && this.enabled) {
            if (System.currentTimeMillis() - this.lastAttack > 2000L) {
                this.rangeText = "Hasn't attacked";
            }
            int minX = this.addX;
            int minY = this.addY;
            int maxX = this.addX + 4 + this.mc.field_71466_p.func_78256_a(this.rangeText);
            int maxY = this.addY + 4 + this.mc.field_71466_p.field_78288_b;
            Color textColor = Color.values()[this.currentColorIndex];
            int textHex = textColor.getHex();
            if (textColor == Color.RAINBOW) {
                textHex = java.awt.Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f);
            }
            Gui.func_73734_a((int)minX, (int)minY, (int)maxX, (int)maxY, (int)0x50000000);
            this.mc.field_71466_p.func_78276_b(this.rangeText, minX + 2, minY + 2, textHex);
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
            if (this.mc.field_71462_r != null) {
                try {
                    this.mc.field_71462_r.func_146269_k();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.showGui) {
            this.mc.func_147108_a((GuiScreen)new ReachDisplayGuiScreen(this));
            this.showGui = false;
        }
    }

    public void setShowGui() {
        this.showGui = true;
    }

    public void setAddX(int addX) {
        this.addX = addX;
    }

    public void setAddY(int addY) {
        this.addY = addY;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCurrentColorIndex(int currentColorIndex) {
        this.currentColorIndex = currentColorIndex;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getCurrentColorIndex() {
        return this.currentColorIndex;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getAddX() {
        return this.addX;
    }

    public int getAddY() {
        return this.addY;
    }

    public void saveConfig() {
        try {
            File file = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "ReachDisplayMod", "values.cfg");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file, false);
            writer.write(this.addX + "\n" + this.addY + "\n" + this.enabled + "\n" + this.currentColorIndex);
            writer.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        try {
            String line;
            File file = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "ReachDisplayMod", "values.cfg");
            if (!file.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                switch (++i) {
                    case 1: {
                        this.addX = Integer.parseInt(line);
                        break;
                    }
                    case 2: {
                        this.addY = Integer.parseInt(line);
                        break;
                    }
                    case 3: {
                        this.enabled = Boolean.parseBoolean(line);
                        break;
                    }
                    case 4: {
                        this.currentColorIndex = Integer.parseInt(line);
                    }
                }
            }
            reader.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

